# Task Management System

A comprehensive task management system built with PHP and MySQL, featuring user authentication, task assignment, progress tracking, points system, and detailed reporting.

## Features

### 1. User Login System
- Secure login for both Users and Admins
- Session-based authentication
- Password hashing using PHP's password_hash()

### 2. Admin Dashboard
- Overview of all users and tasks
- User performance metrics
- Quick access to all management functions

### 3. Task Management
- Create tasks with name, description, and duration
- Set task type (Recurring or One-Time)
- Assign priority levels (High, Medium, Low)
- Assign tasks to specific users
- Task deletion with admin password verification

### 4. User Dashboard
- View assigned tasks
- Real-time countdown timer for tasks
- Filter tasks by status and priority
- Progress tracking with completion percentage

### 5. Points System
- **+1.2 points** for completing a task
- **-1 point** for incomplete/overdue tasks
- Complete points history tracking

### 6. Notifications & Reminders
- Email/mobile notification system (database ready)
- Task assignment notifications
- Due date reminders
- Points deduction notifications

### 7. Progress Tracking
- Individual task completion tracking
- Overall completion percentage
- Performance summaries

### 8. Reports
- Last 10 days report
- Last 15 days report
- Custom date range reports
- Task completion reports
- User performance reports
- Points distribution reports

### 9. Audit Logs
- Complete activity tracking
- User actions logging
- IP address tracking
- Entity-level audit trails

### 10. Task Features
- Notes and attachments support
- Recurring task auto-scheduling
- Task timer display
- Status tracking (Pending, In Progress, Completed, Overdue)

## Installation

### Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- PHP extensions: mysqli, pdo_mysql

### Setup Steps

1. **Clone or download the project**
   ```bash
   cd /path/to/your/web/directory
   ```

2. **Create the database**
   - Import `database.sql` into your MySQL database
   - Or run the SQL commands in your MySQL client

3. **Configure database connection**
   - Edit `config.php`
   - Update database credentials:
     ```php
     define('DB_HOST', 'localhost');
     define('DB_USER', 'your_username');
     define('DB_PASS', 'your_password');
     define('DB_NAME', 'task_management');
     ```

4. **Set up file permissions**
   ```bash
   chmod 755 uploads/
   chmod 644 *.php
   ```

5. **Configure web server**
   - Point your web server document root to the project directory
   - Ensure mod_rewrite is enabled (if using Apache)

6. **Set up cron job (optional but recommended)**
   ```bash
   crontab -e
   ```
   Add this line to run cron jobs every hour:
   ```
   0 * * * * /usr/bin/php /path/to/TaskManagement/cron_jobs.php
   ```

## Default Credentials

After importing the database, you can use these default credentials:

**Admin:**
- Username: `admin`
- Password: `admin123`

**User:**
- Username: `user1`
- Password: `user123`

**⚠️ Important:** Change these passwords immediately after first login!

## File Structure

```
TaskManagement/
├── assets/
│   └── css/
│       └── style.css          # Main stylesheet
├── uploads/                    # File uploads directory
├── config.php                  # Configuration and database connection
├── database.sql                # Database schema
├── index.php                   # Home page
├── login.php                   # Login page
├── logout.php                  # Logout handler
├── dashboard.php               # User dashboard
├── admin_dashboard.php         # Admin dashboard
├── create_task.php             # Task creation form
├── view_task.php               # Task details view
├── complete_task.php           # Task completion handler
├── manage_tasks.php            # Task management (admin)
├── manage_users.php            # User management (admin)
├── user_details.php            # User details view (admin)
├── my_history.php              # User's task history
├── admin_reports.php           # Progress reports
├── audit_logs.php              # Audit log viewer
├── cron_jobs.php               # Scheduled tasks handler
└── README.md                   # This file
```

## Usage

### For Admins

1. **Login** with admin credentials
2. **Create Tasks** via "Create New Task" button
3. **Manage Users** to create new user accounts
4. **View Reports** for progress tracking
5. **Monitor Activity** via audit logs

### For Users

1. **Login** with user credentials
2. **View Dashboard** to see assigned tasks
3. **Complete Tasks** by clicking "Complete" button
4. **View History** to see points and completion history
5. **Add Notes** and **Upload Attachments** to tasks

## Points System

- **Task Completion:** +1.2 points
- **Task Incomplete (Overdue):** -1.0 points
- Points are automatically calculated and tracked
- View points history in "My History" page

## Recurring Tasks

- Set recurrence interval in days
- Tasks automatically recreate after completion
- Next instance is scheduled based on interval
- Notifications sent when recurring task is created

## Notifications

The system includes a notification framework. To implement email notifications:

1. Configure SMTP settings in `config.php`
2. Create a notification sender function
3. Call it when creating notifications in the database

## Security Features

- Password hashing (bcrypt)
- SQL injection prevention (prepared statements)
- XSS protection (htmlspecialchars)
- Session security
- Admin password verification for deletions
- IP address logging

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers (responsive design)

## Responsive Design

The system is fully responsive and works on:
- Desktop computers
- Tablets
- Mobile phones

## Troubleshooting

### Database Connection Error
- Check database credentials in `config.php`
- Ensure MySQL service is running
- Verify database exists

### File Upload Issues
- Check `uploads/` directory permissions
- Verify `MAX_FILE_SIZE` in `config.php`
- Check PHP upload limits in `php.ini`

### Cron Jobs Not Running
- Verify cron service is running
- Check cron job syntax
- Verify PHP path in cron command
- Check file permissions

## License

This project is open source and available for educational and commercial use.

## Support

For issues or questions, please check the code comments or create an issue in the repository.

## Future Enhancements

- Email notification integration
- Mobile app API
- Advanced analytics
- Team collaboration features
- Calendar integration
- Export reports to PDF/Excel
