<?php
require_once 'config.php';
requireAdmin();

$user = getUserInfo();
$conn = getDBConnection();

// Get notifications for header
$notification_count = getNotificationCount();
$header_notifications = getNotifications($_SESSION['user_id'], 10);

// Get statistics
$stats = [];
$stats['total_users'] = $conn->query("SELECT COUNT(*) as count FROM users WHERE role = 'user'")->fetch_assoc()['count'];
$stats['total_tasks'] = $conn->query("SELECT COUNT(*) as count FROM tasks")->fetch_assoc()['count'];
$stats['completed_tasks'] = $conn->query("SELECT COUNT(*) as count FROM tasks WHERE status = 'completed'")->fetch_assoc()['count'];
$stats['pending_tasks'] = $conn->query("SELECT COUNT(*) as count FROM tasks WHERE status = 'pending'")->fetch_assoc()['count'];
$stats['total_points'] = $conn->query("SELECT SUM(points) as total FROM users")->fetch_assoc()['total'] ?? 0;

// Today's statistics
$today_start = date('Y-m-d 00:00:00');
$today_end = date('Y-m-d 23:59:59');
$stats['today_pending'] = $conn->query("SELECT COUNT(*) as count FROM tasks WHERE status IN ('pending', 'in_progress') AND DATE(created_at) = CURDATE()")->fetch_assoc()['count'];
$stats['today_completed'] = $conn->query("SELECT COUNT(*) as count FROM tasks WHERE status = 'completed' AND DATE(completed_at) = CURDATE()")->fetch_assoc()['count'];
$stats['uptown_today_task'] = $conn->query("SELECT COUNT(*) as count FROM tasks WHERE DATE(created_at) = CURDATE()")->fetch_assoc()['count'];
$stats['uptown_today_total'] = $stats['total_tasks']; // Total tasks for the ratio

// Get recent tasks
$recent_tasks = $conn->query("SELECT t.*, u.full_name as assigned_to_name, u2.full_name as created_by_name 
    FROM tasks t 
    LEFT JOIN users u ON t.assigned_to = u.id 
    LEFT JOIN users u2 ON t.created_by = u2.id 
    ORDER BY t.created_at DESC LIMIT 10")->fetch_all(MYSQLI_ASSOC);

// Get user performance
$user_performance = $conn->query("SELECT u.id, u.username, u.full_name, u.points,
    COUNT(DISTINCT t.id) as total_tasks,
    COUNT(DISTINCT CASE WHEN t.status = 'completed' THEN t.id END) as completed_tasks
    FROM users u
    LEFT JOIN tasks t ON t.assigned_to = u.id
    WHERE u.role = 'user'
    GROUP BY u.id
    ORDER BY u.points DESC")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title>Admin Dashboard - Task Management System</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/theme.js"></script>
    <script src="assets/js/notifications.js"></script>
    <script src="assets/js/mobile-menu.js"></script>
</head>
<body class="mobile-app">
    <?php include 'mobile_header.php'; ?>

    <!-- Mobile App Stats Grid -->
    <div class="mobile-stats-grid">
        <div class="mobile-stat-card">
            <div class="mobile-stat-label">Total User</div>
            <div class="mobile-stat-value"><?php echo $stats['total_users']; ?></div>
        </div>
        <div class="mobile-stat-card">
            <div class="mobile-stat-label">Total task</div>
            <div class="mobile-stat-value"><?php echo $stats['total_tasks']; ?></div>
        </div>
        <div class="mobile-stat-card">
            <div class="mobile-stat-label">Today pending</div>
            <div class="mobile-stat-value">
                <span class="highlight"><?php echo $stats['today_pending']; ?></span>
                <span class="total">/<?php echo $stats['total_tasks']; ?></span>
            </div>
        </div>
        <div class="mobile-stat-card">
            <div class="mobile-stat-label">Today completed</div>
            <div class="mobile-stat-value">
                <span class="highlight"><?php echo $stats['today_completed']; ?></span>
                <span class="total">/<?php echo $stats['total_tasks']; ?></span>
            </div>
        </div>
        <div class="mobile-stat-card">
            <div class="mobile-stat-label">Total points of users</div>
            <div class="mobile-stat-value">
                <span class="highlight">+<?php echo number_format($stats['total_points'], 0); ?></span>
            </div>
        </div>
        <div class="mobile-stat-card">
            <div class="mobile-stat-label">Uptown today task</div>
            <div class="mobile-stat-value">
                <span class="highlight"><?php echo $stats['uptown_today_task']; ?></span>
                <span class="total">/<?php echo $stats['uptown_today_total']; ?></span>
            </div>
        </div>
    </div>

    <!-- Mobile App Action Buttons -->
    <div class="mobile-action-buttons">
        <a href="create_task.php" class="mobile-action-btn">Create new task</a>
        <a href="manage_users.php" class="mobile-action-btn">Manage users</a>
        <a href="admin_reports.php" class="mobile-action-btn">View Reports</a>
    </div>

    <div class="container">

        <!-- Recent Tasks -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Recent Tasks</h2>
                <a href="manage_tasks.php" class="btn btn-primary btn-sm">View All</a>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Task Name</th>
                            <th>Assigned To</th>
                            <th>Priority</th>
                            <th>Status</th>
                            <th>Due Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recent_tasks)): ?>
                            <tr>
                                <td colspan="6" class="empty-state">No tasks found</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($recent_tasks as $task): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($task['task_name']); ?></td>
                                    <td><?php echo htmlspecialchars($task['assigned_to_name'] ?? 'Unassigned'); ?></td>
                                    <td><span class="priority-badge priority-<?php echo $task['priority']; ?>"><?php echo ucfirst($task['priority']); ?></span></td>
                                    <td><span class="status-badge status-<?php echo $task['status']; ?>"><?php echo ucfirst(str_replace('_', ' ', $task['status'])); ?></span></td>
                                    <td><?php echo $task['due_date'] ? date('M d, Y H:i', strtotime($task['due_date'])) : 'N/A'; ?></td>
                                    <td>
                                        <a href="view_task.php?id=<?php echo $task['id']; ?>" class="btn btn-primary btn-sm">View</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- User Performance -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">User Performance</h2>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Total Tasks</th>
                            <th>Completed</th>
                            <th>Completion %</th>
                            <th>Total Points</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($user_performance as $perf): 
                            $completion_pct = $perf['total_tasks'] > 0 ? round(($perf['completed_tasks'] / $perf['total_tasks']) * 100, 2) : 0;
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($perf['full_name']); ?></td>
                                <td><?php echo $perf['total_tasks']; ?></td>
                                <td><?php echo $perf['completed_tasks']; ?></td>
                                <td>
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width: <?php echo $completion_pct; ?>%">
                                            <?php echo $completion_pct; ?>%
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo number_format($perf['points'], 2); ?></td>
                                <td>
                                    <a href="user_details.php?id=<?php echo $perf['id']; ?>" class="btn btn-primary btn-sm">View Details</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
