<?php
require_once 'config.php';
requireLogin();

$task_id = intval($_GET['id'] ?? 0);
if (!$task_id) {
    header('Location: dashboard.php');
    exit;
}

$conn = getDBConnection();

// Get task details
$stmt = $conn->prepare("SELECT * FROM tasks WHERE id = ?");
$stmt->bind_param("i", $task_id);
$stmt->execute();
$task = $stmt->get_result()->fetch_assoc();

if (!$task) {
    header('Location: dashboard.php');
    exit;
}

// Check if user is assigned to this task or is admin
if (!isAdmin() && $task['assigned_to'] != $_SESSION['user_id']) {
    header('Location: dashboard.php');
    exit;
}

// Check if already completed
if ($task['status'] === 'completed') {
    header('Location: view_task.php?id=' . $task_id);
    exit;
}

// Mark task as completed
$update_stmt = $conn->prepare("UPDATE tasks SET status = 'completed', completed_at = NOW() WHERE id = ?");
$update_stmt->bind_param("i", $task_id);
$update_stmt->execute();

// Award points
$points = POINTS_COMPLETE;
$points_stmt = $conn->prepare("UPDATE users SET points = points + ? WHERE id = ?");
$points_stmt->bind_param("di", $points, $_SESSION['user_id']);
$points_stmt->execute();

// Record points history
$history_stmt = $conn->prepare("INSERT INTO points_history (user_id, task_id, points, reason) VALUES (?, ?, ?, 'Task completed')");
$history_stmt->bind_param("iid", $_SESSION['user_id'], $task_id, $points);
$history_stmt->execute();

// Record completion history
$completion_stmt = $conn->prepare("INSERT INTO task_completion_history (task_id, user_id, points_earned) VALUES (?, ?, ?)");
$completion_stmt->bind_param("iid", $task_id, $_SESSION['user_id'], $points);
$completion_stmt->execute();

// Handle recurring tasks
if ($task['task_type'] === 'recurring' && $task['recurrence_interval']) {
    $next_due = date('Y-m-d H:i:s', strtotime("+{$task['recurrence_interval']} days"));
    $next_recurrence = date('Y-m-d H:i:s', strtotime("+{$task['recurrence_interval']} days"));
    
    // Create new recurring task instance
    $recur_stmt = $conn->prepare("INSERT INTO tasks (task_name, task_description, task_duration, task_type, recurrence_interval, priority, assigned_to, created_by, due_date, next_recurrence_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $recur_stmt->bind_param("ssisisisss", 
        $task['task_name'], 
        $task['task_description'], 
        $task['task_duration'], 
        $task['task_type'], 
        $task['recurrence_interval'], 
        $task['priority'], 
        $task['assigned_to'], 
        $task['created_by'], 
        $next_due, 
        $next_recurrence
    );
    $recur_stmt->execute();
    
    $new_task_id = $conn->insert_id;
    
    // Create notification
    if ($task['assigned_to']) {
        $notif_stmt = $conn->prepare("INSERT INTO notifications (user_id, task_id, notification_type, message) VALUES (?, ?, 'task_recurred', ?)");
        $message = "Recurring task: {$task['task_name']}";
        $notif_stmt->bind_param("iis", $task['assigned_to'], $new_task_id, $message);
        $notif_stmt->execute();
    }
}

logAudit('task_completed', 'task', $task_id, "Task completed: {$task['task_name']}");

header('Location: view_task.php?id=' . $task_id);
exit;
?>
