<?php
require_once 'config.php';
requireAdmin();

$conn = getDBConnection();

// Handle task deletion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_task'])) {
    $task_id = intval($_POST['task_id'] ?? 0);
    $admin_password = $_POST['admin_password'] ?? '';
    
    if ($task_id && !empty($admin_password)) {
        // Verify admin password
        $user = getUserInfo();
        if ($admin_password === $user['password']) {
            // Get task name for logging
            $task_stmt = $conn->prepare("SELECT task_name FROM tasks WHERE id = ?");
            $task_stmt->bind_param("i", $task_id);
            $task_stmt->execute();
            $task_name = $task_stmt->get_result()->fetch_assoc()['task_name'] ?? 'Unknown';
            
            // Delete task (cascade will handle related records)
            $delete_stmt = $conn->prepare("DELETE FROM tasks WHERE id = ?");
            $delete_stmt->bind_param("i", $task_id);
            $delete_stmt->execute();
            
            logAudit('task_deleted', 'task', $task_id, "Task deleted: {$task_name}");
            header('Location: manage_tasks.php?success=Task deleted successfully');
            exit;
        } else {
            $error = 'Invalid admin password';
        }
    }
}

// Get filter parameters
$filter = $_GET['filter'] ?? 'all';
$priority_filter = $_GET['priority'] ?? 'all';
$search = $_GET['search'] ?? '';

$query = "SELECT t.*, u.full_name as assigned_to_name, u2.full_name as created_by_name 
    FROM tasks t 
    LEFT JOIN users u ON t.assigned_to = u.id 
    LEFT JOIN users u2 ON t.created_by = u2.id 
    WHERE 1=1";

if ($filter === 'completed') {
    $query .= " AND t.status = 'completed'";
} elseif ($filter === 'incomplete') {
    $query .= " AND t.status != 'completed'";
}

if ($priority_filter !== 'all') {
    $query .= " AND t.priority = ?";
}

if (!empty($search)) {
    $query .= " AND (t.task_name LIKE ? OR t.task_description LIKE ?)";
}

$query .= " ORDER BY t.created_at DESC";

$stmt = $conn->prepare($query);
if ($priority_filter !== 'all' && !empty($search)) {
    $search_param = "%{$search}%";
    $stmt->bind_param("sss", $priority_filter, $search_param, $search_param);
} elseif ($priority_filter !== 'all') {
    $stmt->bind_param("s", $priority_filter);
} elseif (!empty($search)) {
    $search_param = "%{$search}%";
    $stmt->bind_param("ss", $search_param, $search_param);
}

$stmt->execute();
$tasks = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title>Manage Tasks - Task Management System</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/theme.js"></script>
    <script src="assets/js/notifications.js"></script>
    <script src="assets/js/mobile-menu.js"></script>
    <script>
        function confirmDelete(taskId, taskName) {
            const password = prompt('Enter admin password to delete task "' + taskName + '":');
            if (password) {
                document.getElementById('delete_task_id').value = taskId;
                document.getElementById('delete_admin_password').value = password;
                document.getElementById('delete_form').submit();
            }
        }
    </script>
</head>
<body class="mobile-app">
    <?php include 'mobile_header.php'; ?>

    <div class="container">
        <?php if (isset($_GET['success'])): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($_GET['success']); ?></div>
        <?php endif; ?>
        <?php if (isset($error)): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="GET" action="" id="delete_form" style="display: none;">
            <input type="hidden" name="delete_task" value="1">
            <input type="hidden" id="delete_task_id" name="task_id">
            <input type="hidden" id="delete_admin_password" name="admin_password">
        </form>
        
        <!-- Filters -->
        <div class="filters">
            <form method="GET" action="" style="display: flex; gap: 1rem; flex-wrap: wrap; width: 100%;">
                <div>
                    <label>Status:</label>
                    <select name="filter">
                        <option value="all" <?php echo $filter === 'all' ? 'selected' : ''; ?>>All</option>
                        <option value="completed" <?php echo $filter === 'completed' ? 'selected' : ''; ?>>Completed</option>
                        <option value="incomplete" <?php echo $filter === 'incomplete' ? 'selected' : ''; ?>>Incomplete</option>
                    </select>
                </div>
                <div>
                    <label>Priority:</label>
                    <select name="priority">
                        <option value="all" <?php echo $priority_filter === 'all' ? 'selected' : ''; ?>>All</option>
                        <option value="high" <?php echo $priority_filter === 'high' ? 'selected' : ''; ?>>High</option>
                        <option value="medium" <?php echo $priority_filter === 'medium' ? 'selected' : ''; ?>>Medium</option>
                        <option value="low" <?php echo $priority_filter === 'low' ? 'selected' : ''; ?>>Low</option>
                    </select>
                </div>
                <div>
                    <label>Search:</label>
                    <input type="text" name="search" placeholder="Task name or description" value="<?php echo htmlspecialchars($search); ?>">
                </div>
                <button type="submit" class="btn btn-primary">Filter</button>
                <a href="manage_tasks.php" class="btn btn-secondary">Clear</a>
            </form>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">All Tasks</h2>
                <a href="create_task.php" class="btn btn-primary btn-sm">Create New Task</a>
            </div>
            
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Task Name</th>
                            <th>Assigned To</th>
                            <th>Priority</th>
                            <th>Status</th>
                            <th>Type</th>
                            <th>Due Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($tasks)): ?>
                            <tr>
                                <td colspan="7" class="empty-state">No tasks found</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($tasks as $task): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($task['task_name']); ?></td>
                                    <td><?php echo htmlspecialchars($task['assigned_to_name'] ?? 'Unassigned'); ?></td>
                                    <td><span class="priority-badge priority-<?php echo $task['priority']; ?>"><?php echo ucfirst($task['priority']); ?></span></td>
                                    <td><span class="status-badge status-<?php echo $task['status']; ?>"><?php echo ucfirst(str_replace('_', ' ', $task['status'])); ?></span></td>
                                    <td><?php echo ucfirst(str_replace('_', ' ', $task['task_type'])); ?></td>
                                    <td><?php echo $task['due_date'] ? date('M d, Y H:i', strtotime($task['due_date'])) : 'N/A'; ?></td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="view_task.php?id=<?php echo $task['id']; ?>" class="btn btn-primary btn-sm">View</a>
                                            <button onclick="confirmDelete(<?php echo $task['id']; ?>, '<?php echo addslashes($task['task_name']); ?>')" class="btn btn-danger btn-sm">Delete</button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
